package gov.va.med.mhv.journal.converter;

import gov.va.med.mhv.journal.data.model.MealItem;
import gov.va.med.mhv.journal.dto.MealItemDTO;

import org.springframework.stereotype.Component;

@Component
public class MealItemConverter {
	
	public MealItemDTO convertDomainMealItem(MealItem mealItem) {
		MealItemDTO mealItemDto = new MealItemDTO();
		
		mealItemDto.setMealItemId(mealItem.getMealItemId());
		mealItemDto.setCreatedDate(mealItem.getCreatedDate());
		mealItemDto.setItem(mealItem.getItem());
		mealItemDto.setModifiedDate(mealItem.getModifiedDate());
		mealItemDto.setMealType(mealItem.getMealType());
		mealItemDto.setServingSize(mealItem.getServingSize());
		mealItemDto.setQuantity(mealItem.getQuantity());
		mealItemDto.setPrepMethod(mealItem.getPrepMethod());
		mealItemDto.setFoodJournalId(mealItem.getFoodJournalId());
		
		return mealItemDto;
	}
	
	
	public MealItem convertDTOMealItem(MealItemDTO mealItemDto) {
		MealItem mealItem = new MealItem();
		
		mealItem.setMealItemId(mealItemDto.getMealItemId());
		mealItem.setCreatedDate(mealItemDto.getCreatedDate());
		mealItem.setItem(mealItemDto.getItem());
		mealItem.setModifiedDate(mealItemDto.getModifiedDate());
		mealItem.setMealType(mealItemDto.getMealType());
		mealItem.setServingSize(mealItemDto.getServingSize());
		mealItem.setQuantity(mealItemDto.getQuantity());
		mealItem.setPrepMethod(mealItemDto.getPrepMethod());
		mealItem.setFoodJournalId(mealItemDto.getFoodJournalId());
		
		return mealItem;
	}
}
